<?php
include "../koneksi.php";
$query = mysqli_query($conn, "SELECT * FROM berita ORDER BY tanggal DESC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<title>Data Berita</title>

<style>
body{
    margin:0;
    font-family:Arial, sans-serif;
    background:#f3f4f6;
}

.wrapper{
    background:#fff;
    max-width:1100px;
    margin:30px auto;
    padding:25px;
    border-radius:16px;
    box-shadow:0 10px 30px rgba(0,0,0,.1);
}

.header{
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:20px;
}

.btn-tambah{
    background:#10b981;
    color:#fff;
    padding:10px 16px;
    border-radius:10px;
    text-decoration:none;
}

table{
    width:100%;
    border-collapse:collapse;
}

th{
    background:#1f2937;
    color:#fff;
}

th, td{
    padding:12px;
    text-align:center;
    border-bottom:1px solid #e5e7eb;
}

th:nth-child(2), td:nth-child(2){
    text-align:left;
}

.btn-edit{
    background:#3b82f6;
    color:#fff;
    padding:6px 10px;
    border-radius:8px;
    text-decoration:none;
}

.btn-hapus{
    background:#ef4444;
    color:#fff;
    padding:6px 10px;
    border-radius:8px;
    text-decoration:none;
}
</style>
</head>

<body>

<?php include "inc/navbar.php"; ?> 

<div class="wrapper">
    <div class="header">
        <h2>Data Berita</h2>
        <a href="berita_tambah.php" class="btn-tambah">+ Tambah Berita</a>
    </div>

    <table>
        <tr>
            <th>No</th>
            <th>Judul</th>
            <th>Tanggal</th>
            <th>Aksi</th>
        </tr>

        <?php $no=1; while($row=mysqli_fetch_assoc($query)): ?>
        <tr>
            <td><?= $no++ ?></td>
            <td><?= $row['judul'] ?></td>
            <td><?= $row['tanggal'] ?></td>
            <td>
                <a href="berita_edit.php?id=<?= $row['id'] ?>" class="btn-edit">Edit</a>
                <a href="berita_hapus.php?id=<?= $row['id'] ?>"
                   class="btn-hapus"
                   onclick="return confirm('Hapus berita ini?')">Hapus</a>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>
</div>

</body>
</html>
