<?php
include "koneksi.php";

$query = mysqli_query($conn, "SELECT * FROM berita");

if (!$query) {
    die("Query error: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Berita Pesantren</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f6f8;
            margin: 0;
        }

        .container {
            width: 90%;
            max-width: 900px;
            margin: 40px auto;
        }

        h1 {
            text-align: center;
            margin-bottom: 30px;
        }

        .card {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }

        .card img {
            width: 100%;
            border-radius: 10px;
            margin-bottom: 15px;
        }

        .tanggal {
            font-size: 13px;
            color: gray;
            margin-bottom: 10px;
        }

        .judul {
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .isi {
            line-height: 1.6;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Berita Pesantren</h1>

    <?php if(mysqli_num_rows($query) > 0): ?>
        <?php while($row = mysqli_fetch_assoc($query)): ?>
            <div class="card">
                <img src="uploads/berita/<?php echo $row['foto']; ?>">
                <div class="tanggal"><?php echo $row['tanggal']; ?></div>
                <div class="judul"><?php echo $row['judul']; ?></div>
                <div class="isi"><?php echo nl2br($row['isi']); ?></div>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <p style="text-align:center;">Belum ada berita.</p>
    <?php endif; ?>
</div>

</body>
</html>
